/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file forced_tracking.cpp
 * \brief Implementation of the bear::universe::forced_tracking class.
 * \author Julien Jorge
 */
#include "universe/forced_tracking.hpp"

/*---------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 * \param moving_item The controlled item.
 * \param target The item to reach.
 * \steps distance The distance to maintain.
 */
bear::universe::forced_tracking::forced_tracking
( physical_item& moving_item, physical_item& reference,
  const bear::universe::position_type& distance )
  : forced_movement(moving_item), m_reference(reference), m_distance(distance)
{

} // forced_tracking::forced_tracking()

/*---------------------------------------------------------------------------*/
/**
 * \brief Start the movement.
 */
void bear::universe::forced_tracking::start()
{
  m_reference.add_dependent_item(m_moving_item);
  next_position();
} // forced_tracking::start()

/*---------------------------------------------------------------------------*/
/**
 * \brief Do an iteration of the movement.
 */
void bear::universe::forced_tracking::next_position()
{
  m_moving_item.set_center_of_mass
    ( m_reference.get_center_of_mass() + m_distance );
} // forced_tracking::progress()

/*---------------------------------------------------------------------------*/
/**
 * \brief Stop the movement.
 */
void bear::universe::forced_tracking::stop()
{
  m_reference.remove_dependent_item(m_moving_item);
} // forced_tracking::stop()

