/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file collision_event.cpp
 * \brief Implementation of the bear::universe::collision_event class.
 * \author Julien Jorge
 */
#include "universe/collision_event/collision_event.hpp"

/*----------------------------------------------------------------------------*/
/**
 * \brief Destructor.
 */
bear::universe::collision_event::~collision_event()
{
  // nothing to do
} // collision_event::~collision_event()

/*----------------------------------------------------------------------------*/
/**
 * \brief Instance's specific code to answer to collisions.
 * \param info Informations on the collision.
 * \param self The first item in the collision.
 * \param that The other item in the collision.
 * \remark The bear::universe::collision_event implementation does nothing.
 */
void bear::universe::collision_event::execute
( const collision_info& info, physical_item& self, physical_item& that ) const
{
  // nothing to do
} // collision_event::execute()
