/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file collision_event_align.tpp
 * \brief Implementation of the bear::universe::collisiont_event_align class.
 * \author Julien Jorge
 */

/*----------------------------------------------------------------------------*/
/**
 * \brief Align an item on one edge of an other item.
 * \param info Informations on the collision.
 * \param self The first item in the collision.
 * \param that The item to align.
 */
template<class Alignment>
void bear::universe::collision_event_align<Alignment>::execute
( const collision_info& info, physical_item& self, physical_item& that ) const
{
  if( !that.is_phantom() )
    {
      Alignment a;

      bear::universe::rectangle_type this_new_box;
      bear::universe::rectangle_type that_new_box;

      this_new_box = self.get_bounding_box();
      that_new_box = that.get_bounding_box();

      a.align( this_new_box, info.other_previous_state().get_position(),
               that_new_box );

      that.set_position(that_new_box.position);
    }
} // collision_event_align::execute()
