/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file collision_event_align_accelerate.tpp
 * \brief Implementation of the bear::universe::collision_event_align_accelerate
 *        class.
 * \author Sebastien Angibaud
 */

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 * \param acceleration_x Acceleration for x-coordinate.
 * \param acceleration_y Acceleration for y-coordinate.
 */
template<class Alignment>
bear::universe::collision_event_align_accelerate<Alignment>::
collision_event_align_accelerate
( const claw::math::coordinate_2d<float>& speed,
  const claw::math::coordinate_2d<float>& acceleration )
{
  m_acceleration.x = acceleration.x;
  m_acceleration.y = acceleration.y;
  m_speed.x = speed.x;
  m_speed.y = speed.y;
} // collision_event_align_accelerate::collision_event_align_accelerate()

/*----------------------------------------------------------------------------*/
/**
 * \brief Align the other item and accelerate him horizontaly if he's on the
 *        left or on the right, or accelerate him verticaly if he's on the top
 *        or at the bottom.
 * \param info Informations on the collision.
 * \param self The first item in the collision.
 * \param that The item to align.
 */
template<class Alignment>
void bear::universe::collision_event_align_accelerate<Alignment>::execute
( const collision_info& info, physical_item& self, physical_item& that ) const
{
  super::execute( info, self, that );

  if( !that.is_phantom() )
    {
      claw::math::vector_2d<float> speed;
      claw::math::vector_2d<float> accel;

      accel = that.get_acceleration();
      speed = that.get_speed();

      speed.x *= m_speed.x;
      speed.y *= m_speed.y;
      accel.x *= m_acceleration.x;
      accel.y *= m_acceleration.y;

      that.set_acceleration( accel );
      that.set_speed( speed );
    }
} // collision_event_align_accelerate::execute()
