/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file horizontal_nearest_align_stop.cpp
 * \brief Implementation of the bear::universe::horizontal_nearest_align_stop
 *        class.
 * \author Julien Jorge
 */
#include "universe/collision_event/horizontal_nearest_align_stop.hpp"

#include <claw/assert.hpp>
#include "universe/collision_event/collision_event_align_stop.hpp"
#include "universe/alignment/align_right.hpp"
#include "universe/alignment/align_left.hpp"

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 * \param left Tell if the left alignment is active.
 * \param right Tell if the right alignment es active.
 */
bear::universe::horizontal_nearest_align_stop::horizontal_nearest_align_stop
( bool left, bool right )
{
  if ( left )
    m_align_left = new collision_event_align_stop<align_left>();
  else
    m_align_left = new collision_event();

  if ( right )
    m_align_right = new collision_event_align_stop<align_right>();
  else
    m_align_right = new collision_event();
} // horizontal_nearest_align_stop::horizontal_nearest_align_stop()

/*----------------------------------------------------------------------------*/
/**
 * \brief Destructor.
 */
bear::universe::horizontal_nearest_align_stop::~horizontal_nearest_align_stop()
{
  delete m_align_left;
  delete m_align_right;
} // horizontal_nearest_align_stop::~horizontal_nearest_align_stop()

/*----------------------------------------------------------------------------*/
/**
 * \brief Apply the collision event of the nearest edge.
 * \param info Informations on the collision.
 * \param self The first item in the collision.
 * \param that The other item in the collision.
 */
void bear::universe::horizontal_nearest_align_stop::execute
( const collision_info& info, physical_item& self, physical_item& that ) const
{
  CLAW_PRECOND( info.get_collision_side() == zone::middle_zone );

  const bear::universe::coordinate_type his_x = 
    info.other_previous_state().get_center_of_mass().x;
  const bear::universe::coordinate_type my_x =
    info.reference_previous_state().get_center_of_mass().x;

  if ( my_x < his_x )
    m_align_right->execute(info, self, that);
  else
    m_align_left->execute(info, self, that);
} //  horizontal_nearest_align_stop::execute()
