/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file define_event_align.hpp
 * \brief A macro defining automatically the collision_event_type class
 *        corresponding to a given a collision_event class taking an alignment
 *        as its only template parameter.
 * \remak This macro works only for collision events whose constructor doesn't
 *        need parameters.
 * \author Julien Jorge
 */
#ifndef __UNIVERSE_DEFINE_EVENT_ALIGN_HPP__
#define __UNIVERSE_DEFINE_EVENT_ALIGN_HPP__

#include "universe/alignment/alignment_type.hpp"

/**
 * \brief A macro defining automatically the collision_event_type class
 *        corresponding to a given a collision_event class taking an alignment
 *        as its only template parameter.
 * \remak This macro works only for collision events whose constructor doesn't
 *        need parameters.
 * \author Julien Jorge
 */
#define DEFINE_ALIGN_EVENT_TYPE( event_class )                          \
  class event_class ## _type                                            \
  {                                                                     \
  public:                                                               \
    template<bear::universe::zone::position Z>                          \
      class type :                                                      \
        public event_class< typename bear::universe::alignment_type<Z>::type > \
      { };                                                              \
  }

#endif // __UNIVERSE_DEFINE_EVENT_ALIGN_HPP__
