/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file forced_movement.hpp
 * \brief The base class for all forced movements.
 * \author Julien Jorge
 */
#ifndef __UNIVERSE_FORCED_MOVEMENT_HPP__
#define __UNIVERSE_FORCED_MOVEMENT_HPP__

#include "universe/physic_rules.hpp"
#include "universe/physical_item.hpp"
#include <claw/math.hpp>

#include "universe/class_export.hpp"

namespace bear
{
  namespace universe
  {

    /**
     * \brief The base class for all forced movements.
     *
     * If an item have a forced movement, the physical rules won't apply to him.
     *
     * \author Julien Jorge
     */
    class UNIVERSE_EXPORT forced_movement
    {
    public:
      forced_movement( physical_item& moving_item );
      virtual ~forced_movement();

      virtual void start() = 0;
      virtual void next_position() = 0;
      virtual void stop() = 0;

    protected:
      /** \brief The item currently moving. */
      physical_item& m_moving_item;

    }; // class forced_movement

  } // namespace universe
} // namespace bear

#endif // __UNIVERSE_FORCED_MOVEMENT_HPP__
