/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file forced_tracking.hpp
 * \brief A forced movement that will force the current item to be at a precise
 *        distance of an other item.
 * \author Julien Jorge
 */
#ifndef __UNIVERSE_FORCED_TRACKING_HPP__
#define __UNIVERSE_FORCED_TRACKING_HPP__

#include "universe/forced_movement.hpp"
#include <claw/math.hpp>

#include "universe/class_export.hpp"

namespace bear
{
  namespace universe
  {
    /**
     * \brief A forced movement that will force the current item to be at a
     *        precise distance of an other item.
     * \author Julien Jorge
     */
    class UNIVERSE_EXPORT forced_tracking:
      public forced_movement
    {
    public:
      forced_tracking( physical_item& moving_item,
                       physical_item& reference,
                       const universe::position_type& distance );

      virtual void start();
      virtual void next_position();
      virtual void stop();

    private:
      /** \brief Our reference. */
      physical_item& m_reference;

      /** \brief Stay at this distance of the reference. */
      universe::position_type m_distance;

    }; // class forced_tracking

  } // namespace universe
} // namespace bear

#endif // __UNIVERSE_FORCED_TRACKING_HPP__

