/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/

/**
 * \file forced_train.hpp
 * \brief A forced movement will trie to bring an item all along a path.
 * \author Angibaud Sebastien
 */
#ifndef __UNIVERSE_FORCED_TRAIN_HPP_
#define __UNIVERSE_FORCED_TRAIN_HPP_

#include <vector>

#include "universe/forced_movement.hpp"
#include "universe/physical_item.hpp"

#include "universe/class_export.hpp"

namespace bear
{
  namespace universe
  {

    /**
     * \brief A forced movement will try to make an item to follow a path.
     * \author Angibaud Sebastien
     */
    class UNIVERSE_EXPORT forced_train:
      public forced_movement
    {
    public:
      typedef std::pair<const physical_item_state*, unsigned int> target;
      typedef std::vector<target> target_list;

    public:
      forced_train( physical_item& moving_item, const target_list& targets );

      void stop();
      void next_position();
      void start();

      void set_loop_back( bool loop_back );
      void set_loops( unsigned int loops );

    private:
      void next_forward( position_type& pos );
      void next_backward( position_type& pos );
      void next( position_type& pos );


      // Attributes
    private:
      /** \brief List of targets and the number of steps for everyone. */
      target_list m_targets;

      /** \brief Current target. */
      unsigned int m_current_target;

      /** \brief Origin position. */
      position_type m_origin_position;

      /** \brief How many steps have we have already doing ? */
      unsigned int m_index;

      /** \brief True if the movement is currently playing. */
      bool m_playing;

      /**
       * \brief How many times the path should take.
       * \remark 0 means non stop.
       */
      unsigned int m_loops;

      /**
       * \brief Should we loop back (true) or jump (false) to the first target
       *        when the targets ends ?
       */
      bool m_loop_back;

      /** \brief Are we going in the normal order ? */
      bool m_forward;

      /** \brief How many full playing have we done ? */
      unsigned int m_play_count;

    }; // class forced_train
  } // namespace universe
} // namespace bear

#endif //  __UNIVERSE_FORCED_TRAIN_HPP_

