/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file forced_translation.hpp
 * \brief A forced movement that will make the current item translating
 * \author Sbastien Angibaud
 */
#ifndef __UNIVERSE_FORCED_TRANSLATION_HPP__
#define __UNIVERSE_FORCED_TRANSLATION_HPP__

#include "universe/forced_movement.hpp"
#include "universe/physical_item_state.hpp"

#include "universe/class_export.hpp"

namespace bear
{
  namespace universe
  {
    /**
     * \brief A forced movement that will make the current item translating.
     *
     * The positions considered for the items are their center of mass.
     *
     * \author Sbastien Angibaud
     */
    class UNIVERSE_EXPORT forced_translation:
      public forced_movement
    {
    public:
      forced_translation
      ( physical_item& moving_item, speed_type speed);

      virtual void start();
      virtual void next_position();
      virtual void stop();

    private:
      /** \brief Speed of the item. */
      speed_type m_speed;

    }; // class forced_translation
  } // namespace universe
} // namespace bear

#endif // __UNIVERSE_FORCED_TRANSLATION_HPP__
