/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file physic_rules.hpp
 * \brief A class to manage the physical behaviour of items and collision
 *        detection.
 * \author Julien Jorge
 */
#ifndef __UNIVERSE_PHYSIC_RULES_HPP__
#define __UNIVERSE_PHYSIC_RULES_HPP__

#include "universe/collision_detection.hpp"
#include <claw/math.hpp>
#include <claw/non_copyable.hpp>

#include "universe/class_export.hpp"

namespace bear
{
  namespace universe
  {
    /**
     * \brief A class to manage the physical behaviour of items and collision
     *        detection.
     * \author Julien Jorge
     */
    class UNIVERSE_EXPORT physic_rules :
      public collision_detection,
      claw::concept::non_copyable
    {
    public:
      /** \brief The type of the parent class. */
      typedef collision_detection super;

    private:
      /** \brief The type of the m_{static,mobile}_items lists. */
      typedef std::list<physical_item*> item_list;

    public:
      physic_rules();

      void add_item( physical_item& item );
      void add_global_item( physical_item& item );
      void begin_listing();
      void end_listing();
      void progress( time_type elapsed_time );

    private:
      void progress_positions( time_type elapsed_time );

      void apply_links() const;

    private:
      /** \brief True if the progress() method is running. */
      bool m_in_progress;

      /** \brief The items without mass : can't collide with another from this
          list. */
      item_list m_static_items;

      /** \brief The items with speed : can collide with anything. */
      item_list m_mobile_items;

      /** \brief The global items : out the active region. */
      item_list m_global_items;

    }; // physic_rules
  } // namespace universe
} // namespace bear

#endif // __UNIVERSE_PHYSIC_RULES_HPP__
