/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file animation.hpp
 * \brief Basic animation based on sprites.
 * \author Julien Jorge
 */
#ifndef __VISUAL_ANIMATION_HPP__
#define __VISUAL_ANIMATION_HPP__

#include <vector>

#include <claw/math.hpp>
#include "visual/sprite.hpp"


#include "visual/class_export.hpp"

namespace bear
{
  namespace visual
  {
    /**
     * \brief Basic animation based on sprites.
     * \author Julien Jorge
     */
    class VISUAL_EXPORT animation
    {
    public: // Types
      typedef std::vector< sprite* > frame_list;

    public: // Operations
      animation( const frame_list& images );
      animation( const animation& that );
      ~animation();

      void reset();
      void next();
      const sprite& get_sprite() const;

      claw::math::coordinate_2d<unsigned int> get_max_size() const;

      void set_loop_back( bool loop_back );
      void set_loops( unsigned int loops );

      double get_alpha_blend() const;
      void  set_alpha_blend( double alpha_blend );

      void flip( bool b );
      void mirror( bool b );

      bool is_flipped() const;
      bool is_mirrored() const;

      bool is_finished() const;

    private:
      void next_forward();
      void next_backward();

    private: // Attributes
      /** \brief Animation's frames. */
      std::vector<sprite*> m_sprites;

      /** \brief Current frame. */
      unsigned int m_index;

      /**
       * \brief How many times the animation should play.
       * \remark 0 means non stop.
       */
      unsigned int m_loops;

      /**
       * \brief Should we loop back (true) or jump (false) to the first frame
       *        when the animation ends ?
       */
      bool m_loop_back;

      /** \brief Are we playing in the normal order ? */
      bool m_forward;

      /** \brief How many full playing have we done ? */
      unsigned int m_play_count;

    }; // class animation

  } // namespace visual
} // namespace bear

#endif // __VISUAL_ANIMATION_HPP__
