/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file progressive_screen_effect.hpp
 * \brief Base class for progressive visual effects on the screen.
 * \author Julien Jorge.
 */
#ifndef __VISUAL_PROGRESSIVE_SCREEN_EFFECT_HPP__
#define __VISUAL_PROGRESSIVE_SCREEN_EFFECT_HPP__

#include "visual/screen_effect.hpp"

#include "visual/class_export.hpp"

namespace bear
{
  namespace visual
  {
    /**
     * \brief Base class for progressive visual effects on the screen.
     * \author Julien Jorge.
     */
    class VISUAL_EXPORT progressive_screen_effect : public screen_effect
    {
    public:
      progressive_screen_effect( double first_value, double last_value,
                                 unsigned int length );

      virtual void apply( claw::graphic::image& target );

    protected:
      virtual void progressive_apply( claw::graphic::image& target,
                                      double coeff ) = 0;

    protected:
      const double m_first_value;
      const double m_last_value;

    private:
      const double m_increment;
      double m_coeff;
    }; // class progressive_screen_effect
  } // namespace visual
} // namespace bear

#endif // __VISUAL_PROGRESSIVE_SCREEN_EFFECT_HPP__
