/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file player_start_position.hpp
 * \brief This class represent the position of a player when a level starts.
 * \author Julien Jorge
 */
#ifndef __BEAR_PLAYER_START_POSITION_HPP__
#define __BEAR_PLAYER_START_POSITION_HPP__

#include "engine/base_item.hpp"

namespace bear
{
  /**
   * \brief This class represent the position of a player when a level starts.
   *
   * You can use this class to instanciate your player class in the level. The
   * instance will be created using the population class and will be added to
   * the world (via get_owner()).
   *
   * \b Template \b parameters:
   * - \a Player The player class in the final application. This class must
   *      inherit from engine::messageable_item and have a constructor taking a
   *      string as its only parameter.
   *
   * \author Julien Jorge
   */
  template<class Player>
  class player_start_position : public engine::base_item
  {
  public:
    /** \brief The type of the parent class. */
    typedef engine::base_item super;

  public:
    player_start_position();

    bool set_u_integer_field( const std::string& name, unsigned int value );
    bool is_valid() const;

    void start();

  private:
    /** \brief The index of the player to create. */
    unsigned int m_player_index;

  }; // class player_start_position
} // namespace bear

#include "generic_items/code/player_start_position.tpp"

#endif // __BEAR_PLAYER_START_POSITION_HPP__
