/*
  Bear Engine

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file slope.hpp
 * \brief A ground that is not horizontal.
 * \author Julien Jorge
 */
#ifndef __BEAR_VISIBLE_SLOPE_HPP__
#define __BEAR_VISIBLE_SLOPE_HPP__

#include "generic_items/invisible_slope.hpp"
#include "engine/item_with_decoration.hpp"

namespace bear
{
  /**
   * \brief A visible ground that is not horizontal.
   * \author Julien Jorge
   */
  typedef engine::item_with_decoration<invisible_slope> visible_slope;
} // namespace bear

#endif // __BEAR_VISIBLE_SLOPE_HPP__
