/*
    Bear Engine - Model compiler

    Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    contact: plee-the-bear@gamned.org

    Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file model_code_value.hpp
 * \brief Codes describing model parameters in a compiled model file.
 * \author Julien Jorge
 */
#ifndef __BEAR_MODEL_CODE_VALUE_HPP__
#define __BEAR_MODEL_CODE_VALUE_HPP__

namespace bear
{
  /**
   * \brief Codes describing model parameters in a compiled model file.
   */
  class model_code_value
  {
  public:
    /** \brief End of file. */
    static const unsigned int eof = 0;

    /** \brief Action. */
    static const unsigned int action = 30;

  }; // class model_code_value
} // namespace bear

#endif // __BEAR_MODEL_CODE_VALUE_HPP__
