/*
    Plee The Bear - Level compiler

    Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    contact: plee-the-bear@gamned.org

    Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file bf/animation.hpp
 * \brief The value of a field of type "animation".
 * \author Julien Jorge
 */
#ifndef __BF_ANIMATION__
#define __BF_ANIMATION__

#include <list>

#include "bf/sprite.hpp"

namespace bf
{
  /**
   * \brief Animation type.
   * \author Julien Jorge
   */
  class animation
  {
    public:
    /** \brief A frame is a element of an animation (a sprite and a time). */
    class frame
    {
    public:
      frame();

      void set_sprite(const sprite& spr);
      void set_duration(double time);

      const bf::sprite& get_sprite() const;
      double get_duration() const;

    private:
      /** \brief The sprite. */
      sprite m_sprite;
      
      /** \brief The time during which the sprite is display. */
      double m_duration;

    }; // class frame

  public:
    animation();
    animation(const animation& anim);

    void set_frames( const std::list<frame>& frames );
    void set_flip_x( bool b );
    void set_flip_y( bool b );
    void set_alpha( double alpha );
    void set_loops( unsigned int loops );
    void set_loop_back( bool b );
    void set_first_index( unsigned int index );
    void set_last_index( unsigned int index );

    bool get_flip_x() const;
    bool get_flip_y() const;
    double get_alpha() const;
    unsigned int get_loops() const;
    bool get_loop_back() const;
    unsigned int get_first_index() const;
    unsigned int get_last_index() const;
    const std::list<frame>& get_frames() const ;
    std::list<frame>& get_frames() ;

    bool empty() const;
    unsigned int nb_frames() const;
    frame& operator[](int index);
    const frame& operator[](int index) const;
    
    void compile( compiled_file& f ) const;

  private:
    /** \brief The frames of the animation. */
    std::list<frame> m_frames;

    /** \brief Flip the animation horizontaly. */
    bool m_flip_x;

    /** \brief Flip the animation verticaly. */
    bool m_flip_y;

    /** \brief Alpha transparency. */
    double m_alpha;

    /** \brief Number of loops. */
    unsigned int m_loops;

    /** \brief Play the animation backward. */
    bool m_loop_back;

    /** \brief The index of the first frame of the loops. */
    unsigned int m_first_index;

    /** \brief The index of the last frame of the loops. */
    unsigned int m_last_index;

  }; // class animation
} // namespace bf

#endif // __BF_ANIMATION__
