/*
    Plee The Bear - Level editor

    Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    contact: plee-the-bear@gamned.org

    Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file bf/code/bear_factory.cpp"
 * \brief Implementation of the bf::bear_factory class.
 * \author Julien Jorge.
 */
#include "bf/bear_factory.hpp"

#include <claw/logger.hpp>

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 */
bf::bear_factory::bear_factory()
  : m_main_frame(NULL)
{
  claw::logger.set( new claw::console_logger() );
  claw::logger.set_level( claw::log_verbose );
} // bear_factory::bear_factory()

/*----------------------------------------------------------------------------*/
/**
 * \brief Destructor.
 */
bf::bear_factory::~bear_factory()
{
  // frames are deleted by wxWidgets

  claw::logger.clear();
} // bear_factory::~bear_factory()

/*----------------------------------------------------------------------------*/
/**
 * \brief Method called when the application is initializing.
 */
bool bf::bear_factory::OnInit()
{
  m_main_frame = new main_frame;
  m_main_frame->Show();

  for (int i=1; i<argc; ++i)
    m_main_frame->load_level( argv[i] );
  
  return true;
} // bear_factory::OnInit()
