/*
    Plee The Bear - Level editor

    Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    contact: plee-the-bear@gamned.org

    Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file bf/impl/bool_edit.tpp
 * \brief Implementation of the bf::bool_edit class.
 * \author Julien Jorge
 */
#include "bf/bool_edit.hpp"

/*----------------------------------------------------------------------------*/
wxString bf::bool_edit::s_true = _("true");
wxString bf::bool_edit::s_false = _("false");

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 * \param parent The windows owning this one.
 * \param v The initial value.
 */
bf::bool_edit::bool_edit( wxWindow& parent, const value_type& v )
  : base_edit<bool_type>(v)
{
  wxArrayString choices;

  choices.Add( s_true );
  choices.Add( s_false );

  Create( &parent, wxID_ANY, wxDefaultPosition, wxDefaultSize, choices );

  init();
} // bool_edit::bool_edit()

/*----------------------------------------------------------------------------*/
/**
 * \brief Check if the displayed value is correct and, if it is, set the
 *        value according to the display.
 */
bool bf::bool_edit::validate()
{
  if ( GetStringSelection() == s_true )
    set_value( bool_type(true) );
  else
    set_value( bool_type(false) );

  return true;
} // bool_edit::validate()

/*----------------------------------------------------------------------------*/
/**
 * \brief Initialise the control.
 */
void bf::bool_edit::init()
{
  Connect( GetId(), wxEVT_COMMAND_CHOICE_SELECTED,
           wxCommandEventHandler(bool_edit::on_change) );
  value_updated();
} // bool_edit::init()

/*----------------------------------------------------------------------------*/
/**
 * \brief Method called when the value has been changed, to update the display.
 */
void bf::bool_edit::value_updated()
{
  if ( get_value().get_value() == true )
    SetSelection(0);
  else
    SetSelection(1);
} // bool_edit::value_updated()

/*----------------------------------------------------------------------------*/
/**
 * \brief Event handler for a change in the text.
 * \param event The event.
 */
void bf::bool_edit::on_change( wxCommandEvent& event )
{
  validate();
} // bool_edit::on_change()
