/*
    Plee The Bear - Level editor

    Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    contact: plee-the-bear@gamned.org

    Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file bf/code/xml_exception.cpp
 * \brief Implementation of the bf::xml* exceptions classes.
 */
#include "bf/xml_exception.hpp"

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 * \param node_name The name of the unexpected node.
 */
bf::xml_bad_node::xml_bad_node( const std::string& node_name )
  : m_msg( "Unexpected node name '" + node_name + "'")
{

} // xml_bad_node::xml_bad_node()

/*----------------------------------------------------------------------------*/
/**
 * \brief Destructor.
 */
bf::xml_bad_node::~xml_bad_node() throw()
{

} // xml_bad_node::xml_bad_node()

/*----------------------------------------------------------------------------*/
/**
 * \brief Get an explanation of the problem.
 */
const char* bf::xml_bad_node::what() const throw()
{
  return m_msg.c_str();
} // xml_bad_node::what()

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 * \param node_name The name of the needed node.
 */
bf::xml_missing_node::xml_missing_node
( const std::string& node_name )
  : m_msg( "Missing node '" + node_name + "'")
{

} // xml_missing_node::xml_missing_node()

/*----------------------------------------------------------------------------*/
/**
 * \brief Destructor.
 */
bf::xml_missing_node::~xml_missing_node() throw()
{

} // xml_missing_node::xml_missing_node()

/*----------------------------------------------------------------------------*/
/**
 * \brief Get an explanation of the problem.
 */
const char* bf::xml_missing_node::what() const throw()
{
  return m_msg.c_str();
} // xml_missing_node::what()

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 * \param property_name The name of the needed property.
 */
bf::xml_missing_property::xml_missing_property
( const std::string& property_name )
  : m_msg( "Missing property '" + property_name + "'")
{

} // xml_missing_property::xml_missing_property()

/*----------------------------------------------------------------------------*/
/**
 * \brief Destructor.
 */
bf::xml_missing_property::~xml_missing_property() throw()
{

} // xml_missing_property::xml_missing_property()

/*----------------------------------------------------------------------------*/
/**
 * \brief Get an explanation of the problem.
 */
const char* bf::xml_missing_property::what() const throw()
{
  return m_msg.c_str();
} // xml_missing_property::what()

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 * \param value The problematic value.
 */
bf::xml_bad_value::xml_bad_value( const std::string& value )
  : m_msg( "Invalid value '" + value + "'")
{

} // xml_bad_value::xml_bad_value()

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 * \param type The expected type.
 * \param value The problematic value.
 */
bf::xml_bad_value::xml_bad_value
( const std::string& type, const std::string& value )
  : m_msg( "Invalid value '" + value + "' (" + type + ")" )
{

} // xml_bad_value::xml_bad_value()

/*----------------------------------------------------------------------------*/
/**
 * \brief Destructor.
 */
bf::xml_bad_value::~xml_bad_value() throw()
{

} // xml_bad_value::xml_bad_value()

/*----------------------------------------------------------------------------*/
/**
 * \brief Get an explanation of the problem.
 */
const char* bf::xml_bad_value::what() const throw()
{
  return m_msg.c_str();
} // xml_bad_value::what()
