/*
    Plee The Bear - Level editor

    Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    contact: plee-the-bear@gamned.org

    Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file bf/item_class_pool.hpp
 * \brief A singleton containing all item classes.
 * \author Julien Jorge
 */
#ifndef __BF_ITEM_CLASS_POOL_HPP__
#define __BF_ITEM_CLASS_POOL_HPP__

#include <boost/filesystem/convenience.hpp>
#include <claw/basic_singleton.hpp>
#include <map>
#include <set>

#include "bf/item_class.hpp"

namespace bf
{
  /**
   * \brief A singleton containing all item classes.
   * \author Julien Jorge
   */
  class item_class_pool
    : public claw::concept::basic_singleton<item_class_pool>
  {
  private:
    typedef std::map<std::string, item_class> item_class_map;

  public:
    typedef claw::wrapped_iterator
    < item_class,
      item_class_map::const_iterator,
      claw::pair_second<item_class_map::value_type> >
    ::iterator_type iterator;

    typedef claw::wrapped_iterator
    < const item_class,
      item_class_map::const_iterator,
      claw::const_pair_second<item_class_map::value_type> >
    ::iterator_type const_iterator;

  public:
    void scan_directory( const std::string& dir_path );

    bool has_item_class( const std::string& class_name ) const;
    const item_class& get_item_class( const std::string& class_name ) const;

    iterator begin();
    iterator end();

    const_iterator begin() const;
    const_iterator end() const;

  private:
    void parse_file( const std::string& file_path );
    void scan_sub_directory( const boost::filesystem::path& dir );

    bool check_super_class
    ( const std::string& current, std::set<std::string>& valid_classes,
      std::set<std::string>& not_valid_classes,
      std::set<std::string>& inherit_set) const;

    bool recursive_super_class_check
    ( const std::string& current, std::set<std::string>& valid_classes,
      std::set<std::string>& not_valid_classes,
      std::set<std::string>& inherit_set) const;

    void inheritance_test();
    void field_unicity_test();

  private:
    /** \brief The item classes. */
    item_class_map m_item_class;

  }; // class item_class_pool
} // namespace bf

#endif // __BF_ITEM_CLASS_POOL_HPP__
