/*
    Plee The Bear - Level editor

    Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    contact: plee-the-bear@gamned.org

    Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file bf/level_properties_frame.hpp
 * \brief The window showing the properties of a level.
 * \author Julien Jorge
 */
#ifndef __BF_LEVEL_PROPERTIES_FRAME_HPP__
#define __BF_LEVEL_PROPERTIES_FRAME_HPP__

#include "bf/level.hpp"

#include <wx/wx.h>
#include <wx/spinctrl.h>

namespace bf
{
  /**
   * \brief The window showing the properties of a level.
   * \author Julien Jorge
   */
  class level_properties_frame:
    public wxDialog
  {
  public:
    level_properties_frame( wxWindow* parent );

    unsigned int get_width() const;
    unsigned int get_height() const;
    unsigned int get_camera_width() const;
    unsigned int get_camera_height() const;
    const std::string& get_music() const;

    void init_from( const level& lvl );

  private:
    void fill_controls();
    void create_controls();
    void create_sizer_controls();
    wxSizer* create_level_sizer();
    wxSizer* create_camera_sizer();
    wxSizer* create_music_sizer();

    void on_ok(wxCommandEvent& event);

  private:
    /** \brief The width of the level. */
    unsigned int m_width;

    /** \brief The height of the level. */
    unsigned int m_height;

    /** \brief The width of the camera. */
    unsigned int m_camera_width;

    /** \brief The height of the camera. */
    unsigned int m_camera_height;

    /** \brief The music to play in this level. */
    std::string m_music;

    /** \brief The text control in which we configure the width of the level. */
    wxSpinCtrl* m_width_text;

    /** \brief The text control in which we configure the height of the
        level. */
    wxSpinCtrl* m_height_text;

    /** \brief The text control in which we configure the height of the
        camera. */
    wxSpinCtrl* m_camera_width_text;

    /** \brief The text control in which we configure the height of the
        camera. */
    wxSpinCtrl* m_camera_height_text;

    /** \brief The control in which we display the music. */
    wxTextCtrl* m_music_text;

    /** \brief The button to select the music. */
    wxButton* m_music_browse;

    /** \brief Minimum width of the level. */
    static const unsigned int s_min_width;

    /** \brief Minimum height of the level. */
    static const unsigned int s_min_height;

    DECLARE_EVENT_TABLE()

  }; // class level_properties_frame
} // namespace bf

#endif // __BF_LEVEL_PROPERTIES_FRAME_HPP__
