/*
    Plee The Bear - Level editor

    Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    contact: plee-the-bear@gamned.org

    Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file bf/level_thumbnail_ctrl.hpp
 * \brief This control display a small global view of the edited level.
 * \author Julien Jorge
 */
#ifndef __BF_LEVEL_THUMBNAIL_CTRL_HPP__
#define __BF_LEVEL_THUMBNAIL_CTRL_HPP__

#include "bf/ingame_view_frame.hpp"

#include <wx/window.h>

namespace bf
{
  /**
   * \brief This control display a small global view of the edited level.
   * \author Julien Jorge
   */
  class level_thumbnail_ctrl
    : public wxWindow
  {
  public:
    level_thumbnail_ctrl( wxWindow* parent );

    void set_view( const ingame_view_frame* view );

  private:
    void render();

    void on_paint(wxPaintEvent& event);

  private:
    /** \brief The view on the edited level. */
    const ingame_view_frame* m_level;

    /** \brief The position of the view in the level view. */
    wxRect m_view_box;

    DECLARE_EVENT_TABLE()

  }; // class level_thumbnail_ctrl
} // namespace bf

#endif // __BF_LEVEL_THUMBNAIL_CTRL_HPP__
