/*
    Plee The Bear - Level editor

    Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    contact: plee-the-bear@gamned.org

    Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file bf/sprite_edit.hpp
 * \brief The window showing the properties of a sprite.
 * \author Sebastien Angibaud
 */
#ifndef __BF_SPRITE_EDIT_HPP__
#define __BF_SPRITE_EDIT_HPP__

#include "bf/base_edit.hpp"
#include "bf/sprite.hpp"
#include "bf/spin_ctrl.hpp"

#include <wx/wx.h>
#include <wx/spinctrl.h>

namespace bf
{
  /**
   * \brief The window showing the properties of a sprite.
   * \author Sebastien Angibaud
   */
  class sprite_edit:
    public wxPanel,
    public base_edit<sprite>
  {
  public:
    /** \brief The identifiers of the controls. */
    enum control_id
      {
        IDC_IMAGE_SELECT,
	IDC_RECTANGLE_CLIP_CHANGE
      }; // enum control_id

  public:
    sprite_edit( wxWindow& parent, const sprite& spr );

    bool validate();
    
  private:
    void value_updated();
    void fill_controls();

    void create_controls();
    void create_sizer_controls();
    wxSizer* create_position_sizer();
    wxSizer* create_size_sizer();
    wxSizer* create_options_sizer();
    wxSizer* create_image_name_sizer();

    void control_sprite_size();

    void on_image_select(wxCommandEvent& event);
    void on_rectangle_clip_change( wxSpinEvent& event );

  private:
    /** \brief The text control in which we configure the left of the 
	sprite. */
    wxSpinCtrl* m_left_text;

    /** \brief The text control in which we configure the top of the
        sprite. */
    wxSpinCtrl* m_top_text;

    /** \brief The text control in which we configure the height of the
        sprite in the image source. */
    wxSpinCtrl* m_clip_width_text;

    /** \brief The text control in which we configure the height of the
        sprite in the image source. */
    wxSpinCtrl* m_clip_height_text;

    /** \brief The text control in which we configure the height of the
        sprite on the screen. */
    wxSpinCtrl* m_width_text;

    /** \brief The text control in which we configure the height of the
        sprite on the screenn. */
    wxSpinCtrl* m_height_text;

    /** \brief The control for configure the flip_x option. */
    wxCheckBox* m_flip_x_box;

    /** \brief The control for configure the flip_y option. */
    wxCheckBox* m_flip_y_box;
    
    /** \brief The control for configure the alpha transparence. */
    bf::spin_ctrl<double>* m_alpha_spin;

    /** \brief The control in which we display the image name. */
    wxTextCtrl* m_image_name_text;

    /** \brief The button to select the music. */
    wxButton* m_image_name_browse;

    DECLARE_EVENT_TABLE()

  }; // class sprite_edit
} // namespace bf

#endif // __BF_SPRITE_EDIT_HPP__
