/*
    Plee The Bear - Level editor

    Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    contact: plee-the-bear@gamned.org

    Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file bf/wx_facilities.hpp
 * \brief Some facilities for using the wxWidget library with other libraries
 *        (namely standard library).
 * \author Julien Jorge
 */
#ifndef __BF_WX_FACILITIES_HPP__
#define __BF_WX_FACILITIES_HPP__

#include <wx/string.h>

namespace bf
{
  /**
   * \brief Create a std::string from a wxString.
   * \param str The reference string.
   */
  inline std::string wx_to_std_string( const wxString& str )
  {
    unsigned int size = str.length();
    char* buffer = new char[size];

    for (unsigned int i=0; i!=size; ++i)
      {
        char c = (char)str[i];

        if (c == 0)
          buffer[i] = '?';
        else
          buffer[i] = c;
      }

    std::string result(buffer, buffer + size);
    delete buffer;

    return result;
  } // wx_to_std_string()

  /**
   * \brief Create a std::string from a wxString.
   * \param str The reference string.
   * \param conv The type of the convertion.
   */
  inline wxString std_to_wx_string
  ( const std::string& str, wxMBConv& conv = wxConvLocal )
  {
    return wxString( str.c_str(), conv );
  } // std_to_wx_string()
} // namespace bf

#endif // __BF_WX_FACILITIES_HPP__
