/*
  Plee The Bear - Model compiler

  Copyright (C) 2005-2008 Julien Jorge, Sébastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file custom_type.tpp
 * \brief Implementation of the mc::custom_type class.
 * \author Julien Jorge
 */

/*----------------------------------------------------------------------------*/
/**
 * \brief Set the value of the variable.
 * \param value The new value.
 */
template< class Type >
void mc::custom_type<Type>::set_value( const Type& value )
{
  m_value = value;
} // custom_type::set_value()

/*----------------------------------------------------------------------------*/
/**
 * \brief Get the value.
 */
template< class Type >
const Type& mc::custom_type<Type>::get_value() const
{
  return m_value;
} // custom_type::get_value()

/*----------------------------------------------------------------------------*/
/**
 * \brief Output the value in the compiled file.
 * \param f The file to write in.
 */
template< class Type >
void mc::custom_type<Type>::output( compiled_file& f ) const
{
  f << m_value;
} // custom_type::output()

