/*
  Plee The Bear - Model compiler

  Copyright (C) 2005-2008 Julien Jorge, Sébastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file image_type.cpp
 * \brief Implementation of the mc::image_type class.
 * \author Julien Jorge
 */
#include "mc/image_type.hpp"

/*----------------------------------------------------------------------------*/
/**
 * \brief Default constructor.
 */
mc::image_type::image_type()
  : m_image_file(""), m_top(0), m_left(0), m_width(0),
    m_height(0), m_flip_x(false), m_flip_y(false), m_alpha(1)
{

} // image_type::image_type()

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 * \param name The name of the image resource to use.
 * \param top Y-coordinate in the image resource.
 * \param left X-coordinate in the image resource.
 * \param width The width in the image resource.
 * \param height The height in the image resource.
 */
mc::image_type::image_type
( const std::string& name, unsigned int top, unsigned int left,
  unsigned int width, unsigned int height )
  : m_image_file(name), m_top(top), m_left(left), m_width(width),
    m_height(height), m_flip_x(false), m_flip_y(false), m_alpha(1)
{

} // image_type::image_type()

/*----------------------------------------------------------------------------*/
/**
 * \brief Write the image in the compiled file.
 * \param f The file to write in.
 */
void mc::image_type::output( compiled_file& f ) const
{
  f << m_image_file << m_left << m_top << m_width << m_height << m_flip_x
    << m_flip_y << m_alpha;
} // image_type::output()

/*----------------------------------------------------------------------------*/
/**
 * \brief Set the name of the image resource to use.
 * \param file The new value.
 */
void mc::image_type::set_image_file( const std::string& file )
{
  m_image_file = file;
} // image_type::set_image_file()

/*----------------------------------------------------------------------------*/
/**
 * \brief Set the Y-coordinate in the image resource.
 * \param top The new value.
 */
void mc::image_type::set_top( const unsigned int top )
{
  m_top = top;
} // image_type::set_top()

/*----------------------------------------------------------------------------*/
/**
 * \brief Set the X-coordinate in the image resource.
 * \param left The new value.
 */
void mc::image_type::set_left( const unsigned int left )
{
  m_left = left;
} // image_type::set_left()

/*----------------------------------------------------------------------------*/
/**
 * \brief Set the width in the image resource.
 * \param width The new value.
 */
void mc::image_type::set_width( const unsigned int width )
{
  m_width = width;
} // image_type::set_width()

/*----------------------------------------------------------------------------*/
/**
 * \brief Set the height in the image resource.
 * \param height The new value.
 */
void mc::image_type::set_height( const unsigned int height )
{
  m_height = height;
} // image_type::set_height()

/*----------------------------------------------------------------------------*/
/**
 * \brief Set the horizontal flip attribute of the image.
 * \param b The new value.
 */
void mc::image_type::set_flip_x( bool b )
{
  m_flip_x = b;
} // image_type::set_flip_x()

/*----------------------------------------------------------------------------*/
/**
 * \brief Set the vertical flip attribute of the image.
 * \param b The new value.
 */
void mc::image_type::set_flip_y( bool b )
{
  m_flip_y = b;
} // image_type::set_flip_y()

/*----------------------------------------------------------------------------*/
/**
 * \brief Set the alpha transparency.
 * \param alpha The new value.
 */
void mc::image_type::set_alpha( float alpha )
{
  m_alpha = alpha;
} // image_type::set_alpha()

