/*
  Plee The Bear - Model compiler

  Copyright (C) 2005-2008 Julien Jorge, Sébastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file node_compiler_action.cpp
 * \brief Implementation of the mc::node_compiler_action class.
 * \author Julien Jorge
 */
#include "mc/node_compiler/node_compiler_action.hpp"

#include <claw/assert.hpp>
#include "mc/node_compiler/node_compiler_animation_type.hpp"
#include "mc/node_compiler/node_compiler_identifier.hpp"

/*----------------------------------------------------------------------------*/
/**
 * \brief Compile a node of type action.
 * \param symbols The symbols of the model.
 * \param the_model The model we are compiling.
 * \param node Node to compile.
 */
void mc::node_compiler_action::compile_node( const symbol_table& symbols,
                                             model& the_model,
                                             const tree_node& node ) const
{
  CLAW_PRECOND( node.value.id() == model_grammar::id_action );
  CLAW_PRECOND( node.children.size() == 3 );

  std::string name, sound;
  animation_type anim;

  node_compiler_animation_type comp_anim;
  node_compiler_identifier comp_id;

  comp_id.compile_node( name, node.children[0] );

  if ( the_model.has_action(name) )
    error( node.value.begin(), node.value.end(),
           "the action '" + name + "' is already defined." );

  if ( node.children[1].value.id() == model_grammar::id_animation_type )
    comp_anim.compile_node( anim, symbols, the_model, node.children[1] );
  else
    {
      std::string anim_name;
      comp_id.compile_node( anim_name, node.children[1] );

      if ( symbols.animation_exists(anim_name) )
        anim = symbols.get_animation(anim_name);
      else
        error( node.value.begin(), node.value.end(),
               "'" + anim_name + "' is not an animation" );
    }

  comp_id.compile_node( sound, node.children[2] );

  if ( the_model.has_sound_resource(sound) )
    the_model.add_action
      ( action(name, anim, the_model.get_sound_resource(sound).get_file()) );
  else
    error( node.value.begin(), node.value.end(),
           "the model doesn't have a sound called '" + sound + "'" );
} // node_compiler_action::compile_node()
