/*
  Plee The Bear - Model compiler

  Copyright (C) 2005-2008 Julien Jorge, Sébastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file node_compiler_bool_type.cpp
 * \brief Implementation of the mc::node_compiler_bool_type class.
 * \author Julien Jorge
 */
#include "mc/node_compiler/node_compiler_bool_type.hpp"

#include <claw/assert.hpp>
#include "mc/model_grammar.hpp"

/*----------------------------------------------------------------------------*/
/**
 * \brief Compile a node of type bool_type.
 * \param val (out) The value read.
 * \param node Node to compile.
 */
void mc::node_compiler_bool_type::compile_node
( bool_type& val, const tree_node& node ) const
{
  CLAW_PRECOND( node.value.id() == model_grammar::id_bool_type );

  std::string s( node.value.begin(), node.value.end() );

  if (s == "true")
    val.set_value(true);
  else
    val.set_value(false);
} // node_compiler_bool_type::compile_node()
