/*
  Plee The Bear - Model compiler

  Copyright (C) 2005-2008 Julien Jorge, Sébastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file node_compiler_model_atom.cpp
 * \brief Implementation of the mc::node_compiler_model_atom class.
 * \author Julien Jorge
 */
#include "mc/node_compiler/node_compiler_model_atom.hpp"

#include <claw/assert.hpp>
#include "mc/model_grammar.hpp"
#include "mc/node_compiler/node_compiler_const_declaration.hpp"
#include "mc/node_compiler/node_compiler_action.hpp"

/*----------------------------------------------------------------------------*/
/**
 * \brief Compile a node of type model_atom.
 * \param symbols The symbols already read in the current model.
 * \param The model we are compiling.
 * \param node Node to compile.
 */
void mc::node_compiler_model_atom::compile_node
( symbol_table& symbols, model& the_model,
  const tree_node& node ) const
{
  CLAW_PRECOND( node.value.id() == model_grammar::id_model_atom );
  CLAW_PRECOND( node.children.size() == 1 );

  switch( node.children[0].value.id().to_long() )
    {
    case model_grammar::id_const_declaration :
      {
        node_compiler_const_declaration comp;
        comp.compile_node( symbols, the_model, node.children[0] );
        break;
      }
    case model_grammar::id_action :
      {
        node_compiler_action comp;
        comp.compile_node( symbols, the_model, node.children[0] );
        break;
      }
    default:
      {
        CLAW_ASSERT( false, "node_compiler_model_atom:Invalid node id." );
      }
    }
} // node_compiler_model_atom::compile_node()
