/*
  Plee The Bear - Model compiler

  Copyright (C) 2005-2008 Julien Jorge, Sébastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file node_compiler_resource_image.cpp
 * \brief Implementation of the mc::node_compiler_resource_image class.
 * \author Julien Jorge
 */
#include "mc/node_compiler/node_compiler_resource_image.hpp"

#include <claw/assert.hpp>
#include "mc/model_grammar.hpp"
#include "mc/node_compiler/node_compiler_identifier.hpp"
#include "mc/node_compiler/node_compiler_filename.hpp"

/*----------------------------------------------------------------------------*/
/**
 * \brief Compile a node of type resource_image.
 * \param the_model The model we are compiling.
 * \param node Node to compile.
 */
void mc::node_compiler_resource_image::compile_node
( model& the_model, const tree_node& node ) const
{
  CLAW_PRECOND( node.children.size() == 2 );
  CLAW_PRECOND( node.value.id() == model_grammar::id_resource_image );

  std::string name;
  std::string file;
  node_compiler_identifier comp_name;
  node_compiler_filename   comp_file;

  comp_name.compile_node( name, node.children[0] );
  comp_file.compile_node( file, node.children[1] );

  if ( the_model.has_image_resource(name) )
    error( node.value.begin(), node.value.end(),
           "An image resource already use this name." );
  else
    the_model.add_image_resource( name, gfx(name, file) );
} // node_compiler_resource_image::compile_node()
