/*
  Plee The Bear - Model compiler

  Copyright (C) 2005-2008 Julien Jorge, Sébastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file node_compiler.hpp
 * \brief Base class for node compilers.
 * \author Julien Jorge
 */
#ifndef __MC_NODE_COMPILER_HPP__
#define __MC_NODE_COMPILER_HPP__

#include <boost/spirit.hpp>
#include <boost/spirit/iterator/position_iterator.hpp>
#include <boost/spirit/tree/parse_tree.hpp>

#include <string>

namespace mc
{
  /**
   * \brief Base class for node compilers.
   * \author Julien Jorge
   */
  class node_compiler
  {
  public:
    /** \brief The type of an iterator on the input data. */
    typedef boost::spirit::position_iterator<const char*> data_iterator;

    typedef boost::spirit::node_iter_data_factory<data_iterator> node_factory;
    typedef boost::spirit::tree_match<data_iterator, node_factory> tree_match;

    /** \brief The type of a node of the tree built by the compiler. */
    typedef tree_match::node_t tree_node;

  protected:
    void error
    ( data_iterator first, data_iterator last, const std::string& msg ) const;

  }; // class node_compiler
} // namespace mc

#endif // __MC_NODE_COMPILER_HPP__
