/*
  Plee The Bear - Model compiler

  Copyright (C) 2005-2008 Julien Jorge, Sébastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file node_compiler_common_image_anim.hpp
 * \brief Compile the common fields of ptb::mc::image_type and
 *        ptb::mc::animation_type
 * \author Julien Jorge
 */
#ifndef __MC_NODE_COMPILER_COMMON_IMAGE_ANIM_HPP__
#define __MC_NODE_COMPILER_COMMON_IMAGE_ANIM_HPP__

#include "mc/model.hpp"
#include "mc/node_compiler/node_compiler.hpp"
#include "mc/symbol_table.hpp"

namespace mc
{
  /**
   * \brief Compile the common fields of ptb::mc::image_type and
   *        ptb::mc::animation_type
   * \author Julien Jorge
   */
  template< class T >
  class node_compiler_common_image_anim:
    public node_compiler
  {
  protected:
    void set_flip_x
    ( T& val, const symbol_table& symbols, const tree_node& node ) const;
    void set_flip_y
    ( T& val, const symbol_table& symbols, const tree_node& node ) const;
    void set_alpha
    ( T& val, const symbol_table& symbols, const tree_node& node ) const;

    bool get_value( unsigned int& val, const symbol_table& symbols,
                    const tree_node& node ) const;
    bool get_value
    ( float& val, const symbol_table& symbols, const tree_node& node ) const;
    bool get_value
    ( bool& val, const symbol_table& symbols, const tree_node& node ) const;

  }; // class node_compiler_common_image_anim
} // namespace mc

#include "mc/node_compiler/code/node_compiler_common_image_anim.tpp"

#endif // __MC_NODE_COMPILER_COMMON_IMAGE_ANIM_HPP__
