/*
  Plee The Bear - Model compiler

  Copyright (C) 2005-2008 Julien Jorge, Sébastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file node_compiler_image_type.hpp
 * \brief Compile the node of the "image_type" rule.
 * \author Julien Jorge
 */
#ifndef __MC_NODE_COMPILER_IMAGE_TYPE_HPP__
#define __MC_NODE_COMPILER_IMAGE_TYPE_HPP__

#include "mc/model.hpp"
#include "mc/node_compiler/node_compiler_common_image_anim.hpp"
#include "mc/image_type.hpp"
#include "mc/symbol_table.hpp"

namespace mc
{
  /**
   * \brief Compile the node of the "image_type" rule.
   * \author Julien Jorge
   */
  class node_compiler_image_type:
    public node_compiler_common_image_anim<image_type>
  {
  public:
    void compile_node( image_type& val, const symbol_table& symbols,
                       const model& the_model, const tree_node& node ) const;

  private:
    void compile_body_item( image_type& val, const symbol_table& symbols,
                            const tree_node& node ) const;

  }; // class node_compiler_image_type
} // namespace mc

#endif // __MC_NODE_COMPILER_IMAGE_TYPE_HPP__
