/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file frame_pause.cpp
 * \brief Implementation of the ptb::frame_pause class.
 * \author Julien Jorge
 */
#include "ptb/frame/frame_pause.hpp"

#include "engine/game.hpp"
#include "ptb/frame/frame_configure.hpp"

/*----------------------------------------------------------------------------*/
const unsigned int ptb::frame_pause::s_pos_resume = 0;
const unsigned int ptb::frame_pause::s_pos_configure = 1;
const unsigned int ptb::frame_pause::s_pos_title_screen = 2;

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 * \param owning_layer The layer onwing the window.
 */
ptb::frame_pause::frame_pause( windows_layer* owning_layer )
  : menu_frame(owning_layer)
{
  bear::engine::game::get_instance().set_pause( true );
  create_controls();
} // frame_pause::frame_pause()

/*----------------------------------------------------------------------------*/
/**
 * \brief Method called when the frame is about to be closed.
 */
bool ptb::frame_pause::on_close()
{
  bear::engine::game::get_instance().set_pause( false );
  return true;
} // frame_pause::on_close()

/*----------------------------------------------------------------------------*/
/**
 * \brief Close the window.
 */
void ptb::frame_pause::quit() const
{
  close_window();
} // frame_pause::quit()

/*----------------------------------------------------------------------------*/
/**
 * \brief Validate the selected action.
 */
void ptb::frame_pause::validate() const
{
  switch ( get_menu().cursor_position() )
    {
    case s_pos_resume:
      quit(); break;
    case s_pos_configure:
      show_window( new frame_configure(m_owning_layer,false) ); break;
    case s_pos_title_screen:
      bear::engine::game::get_instance().set_waiting_level("title_screen");
      break;
    }
} // frame_pause::validate()

/*----------------------------------------------------------------------------*/
/**
 * \brief Create the static text components.
 */
void ptb::frame_pause::create_controls()
{
  char* strings[] = { "resume", "configure", "back_to_title", NULL };

  get_menu().make( strings );
  set_size( get_menu().get_size() );
} // frame_pause::create_controls()
