/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file frame_start_menu.cpp
 * \brief Implementation of the ptb::frame_start_menu class.
 * \author Julien Jorge
 */
#include "ptb/frame/frame_start_menu.hpp"

#include "ptb/frame/message_box.hpp"
#include "engine/game.hpp"

/*----------------------------------------------------------------------------*/
const unsigned int ptb::frame_start_menu::s_pos_one_player = 0;
const unsigned int ptb::frame_start_menu::s_pos_two_players_local = 1;
const unsigned int ptb::frame_start_menu::s_pos_two_players_net = 2;
const unsigned int ptb::frame_start_menu::s_pos_load = 3;
const unsigned int ptb::frame_start_menu::s_pos_back = 4;

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 * \param owning_layer The layer onwing the window.
 */
ptb::frame_start_menu::frame_start_menu( windows_layer* owning_layer )
  : menu_frame(owning_layer)
{
  create_controls();
} // frame_start_menu::frame_start_menu()

/*----------------------------------------------------------------------------*/
/**
 * \brief Validate the selected action.
 */
void ptb::frame_start_menu::validate() const
{
  switch ( get_menu().cursor_position() )
    {
    case s_pos_one_player : start_one_player_game(); break;
    case s_pos_two_players_local : start_two_players_local_game(); break;
    case s_pos_two_players_net : 
    case s_pos_load : 
      show_window( new message_box(m_owning_layer, "not_available") );
      break;
    case s_pos_back : close_window(); break;
    }
} // frame_start_menu::validate()

/*----------------------------------------------------------------------------*/
/**
 * \brief Create the static text components.
 */
void ptb::frame_start_menu::create_controls()
{
  char* strings[] = { "one_player", "two_players_local", "two_players_net",
                      "load", "back", NULL };

  get_menu().make( strings );
  set_size( get_menu().get_size() );
} // frame_start_menu::create_controls()

/*----------------------------------------------------------------------------*/
/**
 * \brief Start the game with one player.
 */
void ptb::frame_start_menu::start_one_player_game() const
{
  bear::engine::game::get_instance().one_player_game();
  bear::engine::game::get_instance().set_waiting_level("tutorial");
} // frame_start_menu::start_one_player_game()

/*----------------------------------------------------------------------------*/
/**
 * \brief Start a local game with two player.
 */
void ptb::frame_start_menu::start_two_players_local_game() const
{
  bear::engine::game::get_instance().two_players_local_game();
  bear::engine::game::get_instance().set_waiting_level("tutorial");
} // frame_start_menu::start_two_player_local_game()
