/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file frame_player_controls.hpp
 * \brief This frame is the configuration menu.
 * \author Julien Jorge
 */
#ifndef __PTB_FRAME_PLAYER_CONTROLS_HPP__
#define __PTB_FRAME_PLAYER_CONTROLS_HPP__

#include "ptb/frame/frame.hpp"
#include "ptb/frame/menu.hpp"
#include "ptb/frame/text_box.hpp"
#include "engine/controller_layout.hpp"

namespace ptb
{
  /**
   * \brief This frame is the configuration menu.
   * \author Julien Jorge
   */
  class frame_player_controls : public frame
  {
  private:
    typedef
    std::pair<unsigned int, bear::input::joystick::joy_code> joystick_pair;

  public:
    frame_player_controls
    ( windows_layer* owning_layer, unsigned int player_index );

  private:
    bool on_key_press( bear::input::keyboard::key_code key );
    bool on_button_press( bear::input::joystick::joy_code button,
                          unsigned int joy_index );
    bool on_mouse_press( bear::input::mouse::mouse_code key,
			 const claw::math::coordinate_2d<unsigned int>& pos );

    void validate();

    void create_controls();
    void show_key_values();

    void edit_mode_off();
    void edit_mode_on();

    void set_key( bear::input::keyboard::key_code key );
    void set_button
    ( bear::input::joystick::joy_code button, unsigned int joy_index );
    void set_button( bear::input::mouse::mouse_code key );

    void save() const;

    std::string build_joystick_button_name
    ( bear::input::joystick::joy_code button, unsigned int joy_index ) const;

  private:
    /** \brief Text zones. */
    menu* m_menu;

    /** \brief The key values presented to the user. */
    std::vector<text_box*> m_keys;

    /** \brief The keyboard key associated with each action. */
    std::vector<bear::input::keyboard::key_code> m_key_codes;

    /** \brief The joystick index and button associated with each action. */
    std::vector<joystick_pair> m_joy_codes;

    /** \brief The mouse button associated with each action. */
    std::vector<bear::input::mouse::mouse_code> m_mouse_codes;

    /** \brief The box that appears when the user select an action. */
    bear::gui::frame* m_focus_box;

    /** \brief Index of the plyer for which we change the controls. */
    const unsigned int m_player_index;

    /** \brief The controller layout of the current player. */
    bear::engine::controller_layout m_controller_layout;

    /** \brief Tell if we're editing an action. */
    bool m_edit_mode;

    /** \brief The actions of the player, in the order they are displayed. */
    static bear::engine::player::action s_actions[];

    /**
     * \name Actions in the menu.
     * The positions of the actions in the menu.
     */
    /** \{ */
    static const unsigned int s_pos_back;
    static const unsigned int s_pos_save;
    /** \} */

    /** \brief Number of actions in the menu. */
    static const unsigned int s_action_count;

    /** \brief The width of the text boxes. */
    static const unsigned int s_text_box_width;

    /** \brief The width of the margins. */
    static const unsigned int s_margin;

    /** \brief The heignt of the line_space. */
    static const unsigned int s_line_space;

  }; // class frame_player_controls
} // namespace ptb

#endif // __PTB_FRAME_PLAYER_CONTROLS_HPP__
