/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file add_gui_layer.cpp
 * \brief Implementation of the ptb::add_gui_layer class.
 * \author Julien Jorge
 */
#include "ptb/item/add_gui_layer.hpp"

#include "engine/export.hpp"
#include "ptb/export.hpp"
#include "engine/game.hpp"
#include "ptb/layer/gui_layer.hpp"
#include "ptb/layer/main_menu_layer.hpp"

BASE_ITEM_EXPORT( add_gui_layer, ptb )

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 */
ptb::add_gui_layer::add_gui_layer()
{
  set_mass(0);
} // add_gui_layer::add_gui_layer()

/*----------------------------------------------------------------------------*/
/**
 * \brief Show the menu.
 */
void ptb::add_gui_layer::start()
{
  /** \brief The layers to add. */
  std::vector<bear::engine::gui_layer*> sub_layers;

  for ( unsigned int i=0; i!=m_sub_layers.size(); ++i )
    sub_layers.push_back( create_layer(m_sub_layers[i]) );

  bear::engine::game::get_instance().set_gui_layer( new gui_layer(sub_layers) );
} // add_gui_layer::start()

/*----------------------------------------------------------------------------*/
/**
 * \brief Set a field of type <list of string>.
 * \param name The name of the field.
 * \param value The new value of the field.
 * \return false if the field "name" is unknow, true otherwise.
 */
bool ptb::add_gui_layer::set_string_list_field
( const std::string& name, const std::vector<std::string>& value )
{
  bool result;

  if ( name == "layer" )
    {
      result = true;
      m_sub_layers = value;
    }
  else
    result = super::set_string_list_field( name, value );

  return result;
} // add_gui_layer::set_string_field()

/*----------------------------------------------------------------------------*/
/**
 * \brief Create a gui layer.
 * \param name The name of the layer class.
 */
bear::engine::gui_layer*
ptb::add_gui_layer::create_layer( const std::string& name ) const
{
  bear::engine::gui_layer* result = NULL;

  if (name == "main_menu_layer")
    result =
      new main_menu_layer( get_position().cast_value_type_to<unsigned int>() );
  else
    {
      gui_layer_export_function_type func;
      std::string layer_id = gui_layer_export_function_name( name );
      bear::engine::libraries_pool&
        symbols( bear::engine::game::get_instance().get_symbols() );

      if ( !symbols.have_symbol(layer_id) )
          claw::logger << claw::log_error << "Invalid layer identifier: '"
                       << name << "'" << claw::lendl;
      else
        {
          func = symbols.get_symbol<gui_layer_export_function_type>(layer_id);
          result = func();
        }
    }

  return result;
} // add_gui_layer::create_layer()
