/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file soul.cpp
 * \brief Implementation of the ptb::soul class.
 * \author Sbastien Angibaud
 */
#include "ptb/item/soul.hpp"
#include "ptb/item/plee/plee.hpp"
#include "engine/export.hpp"

#include "universe/forced_translation.hpp"
#include "universe/physical_item_state.hpp"

BASE_ITEM_EXPORT( soul, ptb )

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 */
ptb::soul::soul()
{
  m_energy = 0;

  set_phantom(true);
  set_can_move_items(false);
  set_mass(1);
  set_friction( 1.02 );
  set_gravity( bear::universe::force_type(0, -0.01) );
} // soul::soul()

/*----------------------------------------------------------------------------*/
/**
 * \brief Destructor.
 */
ptb::soul::~soul()
{
} // soul::soul()

/*----------------------------------------------------------------------------*/
/**
 * \brief A collision occured, the strongest item has the control.
 * \param that The other item of the collision.
 * \param old_self The state to consider for the current item.
 * \param old_that The state to consider for the item "that".
 */
void ptb::soul::hit
( base_item& that, const physical_item_state& old_self,
  const physical_item_state& old_that )
{
  ptb::plee* other = dynamic_cast<ptb::plee*>(&that);

  if (other != NULL)
    {
      other->receive_energy(m_energy);
      m_energy = 0;
      kill();
    }
} // soul::hit()

/*----------------------------------------------------------------------------*/
/**
 * \brief Set a field of type \c unsigned \c integer.
 * \param name The name of the field.
 * \param value The new value of the field.
 * \return false if the field "name" is unknow, true otherwise.
 */
bool ptb::soul::set_u_integer_field
( const std::string& name, unsigned int value )
{
  bool ok = true;

  if (name == "energy")
    m_energy = value;
  else
    ok = super::set_u_integer_field(name,value);

  return ok;
} // soul::set_u_integer_field()


/*---------------------------------------------------------------------------*/
/**
 * \brief Inform the item tat he left the active region.
 */
void ptb::soul::left_active_region()
{
  kill();
} // ptb::soul::left_active_region()
