/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file headstone.hpp
 * \brief The class describing a headstone.
 * \author Sbastien Angibaud
 */
#ifndef __PTB_HEADSTONE_HPP__
#define __PTB_HEADSTONE_HPP__

#include "engine/base_item.hpp"
#include "engine/model.hpp"

namespace ptb
{
  /**
   * \brief The class describing a headstone.
   * \author Sbastien Angibaud
   * The custom fields of this class are :
   *  - \a energy: \c Energy of the soul,
   *  - \a pos_bottom: \c The bottom position,
   *  - \a soul_animation: \c The animation of the soul.
   */
  class headstone:
    public bear::engine::model<bear::engine::base_item>
  {
  public:
    /** \brief The type of the parent class. */
    typedef bear::engine::model<bear::engine::base_item> super;

  public:
    headstone();
    ~headstone();

    void start();
    void progress( bear::universe::time_type elapsed_time );
    bool is_valid() const;

    bool set_u_integer_field( const std::string& name, unsigned int value );
    bool set_real_field( const std::string& name,  double value );
    bool set_animation_field
    ( const std::string& name, bear::visual::animation* value );

    void set_dependent_item(physical_item* item);

  private:
    void create_soul() const;

  private:
    /** \brief Indicates if the soul has appeared. */
    bool m_soul_has_appeared;

    /** \brief The energy of the soul. */
    unsigned int m_soul_energy;

    /** \brief The soul animation. */
    bear::visual::animation* m_soul_animation;

    /** \brief Indicates the time when headstone appears. */
    bear::universe::time_type m_time_start;

    /** \brief The time over which the soul appears.*/
    static const bear::universe::time_type s_time_to_appear;

  }; // class headstone
} // namespace ptb

#endif // __PTB_HEADSTONE_HPP__
