/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file state_plee.cpp
 * \brief Implementation of the ptb::state_plee class.
 * \author Sebastien Angibaud
 */
#include "ptb/item/plee/state_plee.hpp"

const int ptb::state_plee::s_speed_to_run = 11;

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 */
ptb::state_plee::state_plee( ptb::plee* plee_instance )
{
  m_plee_instance = plee_instance;
} // state_plee::state_plee()

/*---------------------------------------------------------------------------*/
/**
 * \brief Do one iteration in the progression of the item.
 * \param elapsed_time Elapsed time since the last call.
 */
void ptb::state_plee::progress( bear::universe::time_type elapsed_time )
{
  m_plee_instance->plee::super::progress(elapsed_time);
} // state_plee::progress()

/*----------------------------------------------------------------------------*/
/**
 * \brief Get the sprite representing the item.
 * \param visuals (out) The sprites of the item, and their positions.
 */
void ptb::state_plee::get_visual
( std::list<bear::engine::scene_visual>& visuals ) const
{
} // state_pleel::get_visual()

/*---------------------------------------------------------------------------*/
/**
 * \brief Teste if Plee walk and change state thereof.
 *         Return true if Plee walk.
 */
bool ptb::state_plee::test_walk()
{
  bool result = false;
  
  if ( m_plee_instance->has_bottom_contact() )
    {
      bear::universe::speed_type speed;
      speed = m_plee_instance->get_speed();
  
      if( abs((int)speed.x) >= s_speed_to_run )
        {
          result = true;
          m_plee_instance->set_state(plee::run_state);
        }
      else if( speed.x != 0 )
        {
          result = true;
          m_plee_instance->set_state(plee::walk_state);
        }
    }

  return result;
} // state_plee::test_walk_run()

/*---------------------------------------------------------------------------*/
/**
 * \brief Teste if Plee walk, run or is idle and change state thereof.
 *         Return true if Plee has a bottom contact.
 */
bool ptb::state_plee::test_bottom_contact()
{
  bool result = false;
  
  if ( m_plee_instance->has_bottom_contact() )
    {
      bear::universe::speed_type speed;
      speed = m_plee_instance->get_speed();
  
      if( abs((int)speed.x) >= s_speed_to_run )
        m_plee_instance->set_state(plee::run_state);
      else if( speed.x != 0 )
        m_plee_instance->set_state(plee::walk_state);
      else
        m_plee_instance->set_state(plee::idle_state);

      result = true;
    }

  return result;
} // state_plee::test_bottom_contact()

/*---------------------------------------------------------------------------*/
/**
 * \brief Teste if Plee is in the sky and change state thereof.
 *         Return true if Plee is in the sky.
 */
bool ptb::state_plee::test_in_sky()
{
  bool result = false;
  
  if ( !m_plee_instance->has_bottom_contact() )
    {
      result = true;
      bear::universe::speed_type speed;
      speed = m_plee_instance->get_speed();
      
      if( speed.y >= 0 )
        m_plee_instance->set_state(plee::fall_state);
      else
        m_plee_instance->set_state(plee::jump_state);
    }
  
  return result;
} // state_plee::test_in_sky()

/*----------------------------------------------------------------------------*/
/**
 * \brief Move the plee to the left.
 */
void ptb::state_plee::do_move_left()
{
  m_plee_instance->add_force( bear::universe::force_type(-1, 0) );
} // state_plee::do_move_left()

/*----------------------------------------------------------------------------*/
/**
 * \brief Move the plee to the left.
 */
void ptb::state_plee::do_move_right()
{
  m_plee_instance->add_force( bear::universe::force_type(1, 0) );
} // state_plee::do_move_right()

/*----------------------------------------------------------------------------*/
/**
 * \brief Do a jump.
 */
void ptb::state_plee::do_jump()
{
  if ( m_plee_instance->has_bottom_contact() )
    {
      m_plee_instance->set_state(plee::jump_state);
      m_plee_instance->add_force( bear::universe::force_type(0, -50) ); //-70
    }
} // state_plee::do_jump()

/*----------------------------------------------------------------------------*/
/**
 * \brief Stop an vertical jump.
 */
void ptb::state_plee::do_stop_vertical_jump()
{

} // state_plee::do_stop_vertical_jump()

/*----------------------------------------------------------------------------*/
/**
 * \brief Make the plee doing slap.
 */
void ptb::state_plee::do_slap()
{
  m_plee_instance->set_state(plee::slap_state);
} // state_plee::do_slap()

/*----------------------------------------------------------------------------*/
/**
 * \brief Make the plee look up.
 */
void ptb::state_plee::do_look_up()
{

} // state_plee::do_look_up()

/*----------------------------------------------------------------------------*/
/**
 * \brief Stop to look up.
 */
void ptb::state_plee::do_stop_look_up()
{

} // state_plee::do_stop_look_up()

/*----------------------------------------------------------------------------*/
/**
 * \brief Continue to look up.
 */
void ptb::state_plee::do_continue_look_up()
{

} // state_plee::do_continue_look_up()

/*----------------------------------------------------------------------------*/
/**
 * \brief Make the plee crouch.
 */
void ptb::state_plee::do_crouch()
{

} // state_plee::do_crouch()

/*----------------------------------------------------------------------------*/
/**
 * \brief Make the plee continue to crouch.
 */
void ptb::state_plee::do_continue_crouch()
{

} // state_plee::do_continue_crouch()

/*----------------------------------------------------------------------------*/
/**
 * \brief Stop to crouch.
 */
void ptb::state_plee::do_stop_crouch()
{

} // state_plee::do_stop_crouch()

/*----------------------------------------------------------------------------*/
/**
 * \brief To unchain Plee.
 */
void ptb::state_plee::unchain()
{

} // state_plee::unchain()

/*----------------------------------------------------------------------------*/
/**
 * \brief To chain Plee.
 */
void ptb::state_plee::chain()
{
  m_plee_instance->set_state(plee::captive_state);
} // state_plee::chain()

/*----------------------------------------------------------------------------*/
/**
 * \brief Plee want start throw.
 */
void ptb::state_plee::do_start_throw()
{
  m_plee_instance->set_state(plee::start_throw_state);
} // state_plee::do_start_throw()

/*----------------------------------------------------------------------------*/
/**
 * \brief Plee want throw.
 */
void ptb::state_plee::do_stop_throw()
{

} // state_plee::do_stop_throw()

/*----------------------------------------------------------------------------*/
/**
 * \brief Set an animation.
 */
void ptb::state_plee::set_animation
( const std::string& name, bear::visual::animation* value)
{
} // state_plee::set_animation()
