/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file state_run.cpp
 * \brief Implementation of the ptb::state_run class.
 * \author Sebastien Angibaud
 */
#include "ptb/item/plee/state_run.hpp"

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 */
ptb::state_run::state_run(  ptb::plee* plee_instance )
  : state_plee(plee_instance)
{

} // state_run::state_run()

/*----------------------------------------------------------------------------*/
/**
 * \brief Return the name of the state.
 */
std::string ptb::state_run::get_name() const
{
  return "run";
} // state_run::get_namee()

/*----------------------------------------------------------------------------*/
/**
 * \brief Initialization of this state.
 */
void ptb::state_run::start()
{
  m_plee_instance->set_status_look_up(false);
  m_plee_instance->set_status_crouch(false);
  m_plee_instance->start_action_parent("run");
} // state_run::start()

/*---------------------------------------------------------------------------*/
/**
 * \brief Do one iteration in the progression of the item.
 * \param elapsed_time Elapsed time since the last call.
 */
void ptb::state_run::progress( bear::universe::time_type elapsed_time )
{
  super::progress(elapsed_time);
  
  if ( m_plee_instance->has_bottom_contact() )
    {
      bear::universe::speed_type speed;
      speed = m_plee_instance->get_speed();

      if( abs((int)speed.x) < s_speed_to_run )
        if( speed.x == 0 )
          m_plee_instance->set_state(plee::idle_state);
        else
          m_plee_instance->set_state(plee::walk_state);
    }
  else
    test_in_sky();
} // state_run::progress()

/*----------------------------------------------------------------------------*/
/**
 * \brief Move the plee to the left.
 */
void ptb::state_run::do_move_left()
{
  m_plee_instance->add_force( bear::universe::force_type(-2, 0) );
} // state_run::do_move_left()

/*----------------------------------------------------------------------------*/
/**
 * \brief Move the plee to the left.
 */
void ptb::state_run::do_move_right()
{
  m_plee_instance->add_force( bear::universe::force_type(2, 0) );
} // state_run::do_move_right()
