/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file state_slap.cpp
 * \brief Implementation of the ptb::state_slap class.
 * \author Sebastien Angibaud
 */
#include "ptb/item/plee/state_slap.hpp"

const bear::universe::time_type ptb::state_slap::s_time_to_stop_slap = 0.25;

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 */
ptb::state_slap::state_slap( ptb::plee* plee_instance )
  : state_plee(plee_instance)
{

} // state_slap::state_slap()

/*----------------------------------------------------------------------------*/
/**
 * \brief Return the name of the state.
 */
std::string ptb::state_slap::get_name() const
{
  return "slap";
} // state_slap::get_name()

/*----------------------------------------------------------------------------*/
/**
 * \brief Initialization of this state.
 */
void ptb::state_slap::start()
{
  m_plee_instance->start_action_parent("slap");
  m_plee_instance->set_offensive_phase(true);
  m_plee_instance->set_defensive_power(monster::normal_attack,true);
  m_slap_time = 0;
} // state_slap::start()

/*----------------------------------------------------------------------------*/
/**
 * \brief The end of the action.
 */
void ptb::state_slap::stop()
{
  m_plee_instance->set_offensive_phase(false);
  m_plee_instance->set_defensive_power(monster::normal_attack,false);
} // state_slap::stop()

/*---------------------------------------------------------------------------*/
/**
 * \brief Do one iteration in the progression of the item.
 * \param elapsed_time Elapsed time since the last call.
 */
void ptb::state_slap::progress( bear::universe::time_type elapsed_time )
{
  super::progress(elapsed_time);

  m_slap_time += elapsed_time;
  
  if ( m_slap_time >= s_time_to_stop_slap )
    m_plee_instance->set_state(plee::idle_state);
} // state_slap::progress()

/*----------------------------------------------------------------------------*/
/**
 * \brief Make the plee doing slap.
 */
void ptb::state_slap::do_slap()
{
  // Plee can't do a new slap.
} // state_slap::do_slap()
