/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file soul.hpp
 * \brief The class describing a soul.
 * \author Sbastien Angibaud
 */
#ifndef __PTB_SOUL_HPP__
#define __PTB_SOUL_HPP__

#include "engine/base_item.hpp"
#include "engine/item_with_decoration.hpp"

namespace ptb
{
  /**
   * \brief The class describing a soul.
   * \author Sbastien Angibaud
   */
  class soul:
    public bear::engine::item_with_decoration<bear::engine::base_item>
  {
  public:
    /** \brief The type of the parent class. */
    typedef bear::engine::item_with_decoration<bear::engine::base_item> super;

  public:
    soul();
    ~soul();

    virtual bool set_u_integer_field(const std::string& name, 
                                     unsigned int value );
   
    virtual void hit( base_item& that, const physical_item_state& old_self,
                      const physical_item_state& old_that );

    void left_active_region();

  private:
    /** \brief The energy of the soul. */
    unsigned int m_energy;

  }; // class soul
} // namespace ptb

#endif // __PTB_SOUL_HPP__
