/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file link_layer.cpp
 * \brief Implementation of the ptb::link_layer class.
 * \author Julien Jorge
 */
#include "ptb/layer/link_layer.hpp"

#include "universe/link/base_link.hpp"
#include "engine/camera.hpp"
#include "ptb/export.hpp"

GUI_LAYER_EXPORT( link_layer, ptb )

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 */
ptb::link_layer::link_layer()
  : base_debugging_layer(bear::input::keyboard::kc_F4)
{

} // link_layer::link_layer()

/*----------------------------------------------------------------------------*/
/**
 * \brief Render the links between the items.
 * \param items The items to draw.
 * \param delta The delta to apply to the position of the items.
 * \param screen The screen on which we draw.
 */
void ptb::link_layer::render
( const std::list<bear::engine::base_item*>& items,
  const bear::universe::position_type& delta, bear::visual::screen& screen )
{
  std::list<bear::engine::base_item*>::const_iterator it;
  claw::math::coordinate_2d<unsigned int> points[2];
  bear::universe::physical_item::const_link_iterator it_link;

  const claw::graphic::pixel32 color(255, 0, 0, 255);

  for (it=items.begin(); it!=items.end(); ++it)
    for (it_link=(*it)->links_begin(); it_link!=(*it)->links_end(); ++it_link)
      {
        const bear::universe::physical_item& first =
          (*it_link)->get_first_item();
        const bear::universe::physical_item& second =
          (*it_link)->get_second_item();

        bear::universe::position_type pos = first.get_center_of_mass() - delta;
        points[0] = pos.cast_value_type_to<unsigned int>();

        pos = second.get_center_of_mass() - delta;
        points[1] = pos.cast_value_type_to<unsigned int>();
	
        screen.draw_line( color, points, points + 2, 5 );
      }
} // link_layer::draw_boxes()
