/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file wireframe_layer.cpp
 * \brief Implementation of the ptb::wireframe_layer class.
 * \author Julien Jorge
 */
#include "ptb/layer/wireframe_layer.hpp"

#include "ptb/export.hpp"

GUI_LAYER_EXPORT( wireframe_layer, ptb )

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 */
ptb::wireframe_layer::wireframe_layer()
  : base_debugging_layer(bear::input::keyboard::kc_F3)
{

} // wireframe_layer::wireframe_layer()

/*----------------------------------------------------------------------------*/
/**
 * \brief Render the boxes of the items.
 * \param items The items to draw.
 * \param delta The delta to apply to the position of the items.
 * \param screen The screen on which we draw.
 */
void ptb::wireframe_layer::render
( const std::list<bear::engine::base_item*>& items,
  const bear::universe::position_type& delta, bear::visual::screen& screen )
{
  std::list<bear::engine::base_item*>::const_iterator it;
  claw::math::coordinate_2d<int> points[5];

  claw::graphic::pixel32 color;

  color.components.alpha = 255;

  for (it=items.begin(); it!=items.end(); ++it)
    {
      uintptr_t addr = reinterpret_cast<uintptr_t>(*it);
      const claw::math::rectangle<int> box
        ( ((*it)->get_position() - delta).cast_value_type_to<int>(),
          (*it)->get_size().cast_value_type_to<int>() );

      color.components.red = (~addr & 0xFF);
      color.components.green =  (~addr & 0xFF00) >> 8;
      color.components.blue = (~addr & 0xFF0000) >> 16;

      points[0] = box.position;
      points[1] = points[0];
      points[1].x += box.width;
      points[2] = points[1];
      points[2].y += box.height;
      points[3] = points[0];
      points[3].y += box.height;
      points[4] = points[0];

      screen.draw_line( color, points, points + 5 );
    }
} // wireframe_layer::draw_boxes()
