/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file windows_layer.hpp
 * \brief The windows_layer is a layer containing the windows.
 * \author Julien Jorge
 */
#ifndef __PTB_WINDOWS_LAYER_HPP__
#define __PTB_WINDOWS_LAYER_HPP__

#include "engine/layer/gui_layer.hpp"
#include "input/keyboard.hpp"
#include "input/joystick.hpp"

#include <stack>

namespace ptb
{
  class frame;

  /**
   * \brief The windows_layer is a layer containing windows.
   * \author Julien Jorge
   */
  class windows_layer : public bear::engine::gui_layer
  {
  private:
    /** \brief Informations on a window in the stack. */
    typedef frame* window_item;

  public:
    windows_layer();
    ~windows_layer();

    bool key_pressed( bear::input::keyboard::key_code key );
    bool button_pressed( bear::input::joystick::joy_code button,
                         unsigned int joy_index );
    bool mouse_pressed( bear::input::mouse::mouse_code key,
                        const claw::math::coordinate_2d<unsigned int>& pos );
    bool mouse_move( const claw::math::coordinate_2d<unsigned int>& pos );

    void render( bear::visual::screen& screen );

    void clear();
    void show_centered_window( window_item wnd );
    void show_window( window_item wnd );

    bool close_window();

  private:
    /** \brief The pending windows. */
    std::stack<window_item> m_windows;

  }; // class windows_layer
} // namespace ptb

#endif // __PTB_WINDOWS_LAYER_HPP__
