/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file monster.hpp
 * \brief The base of a monster.
 * \author S�bastien Angibaud
 */
#ifndef __PTB_MONSTER_HPP__
#define __PTB_MONSTER_HPP__

#include <claw/math.hpp>
#include "time/time_reference.hpp"
#include <vector>
#include <string>

namespace ptb
{
  /**
   * \brief The different type of monster.
   */
  class monster
  {
  public:
     /** \brief The different categories of monster. */
    enum monster_type
      {
        player_monster = 0,
        ennemy_monster,
        stone_monster,
        nature_monster
      }; // enum monster_type

    enum attack_type
      {
        normal_attack = 0,
	water_attack,
        fire_attack,
        air_attack,
        indefensible_attack	
      }; // enum attack_type

    /** \brief The number of attacks. */
    static const unsigned int s_attack_count;

  public:
    monster();
    virtual ~monster();

    void receive_an_attack( monster& attacker );

    void set_invincible(const bool invincible);
    void set_offensive_phase(const bool offensive_phase);
    void set_defensive_power(const attack_type index, const bool statut);

    monster_type get_monster_type() const;
    void set_monster_creator(monster* creator);
    monster* get_monster_creator() const;
    unsigned int get_energy() const;

  protected:
    void to_string( std::string& str ) const;

  private:
    virtual void remove_energy( unsigned int energy );
    bool is_vulnerable( monster& attacker ) const;

  protected:
    void injure();
    void finish_injure();
    virtual void has_attacked();

  protected:
    /** \brief Force of attack. */
    unsigned int m_offensive_force;

    /** \brief Remaining energy of the monster. */
    unsigned int m_energy;

    /** \brief Indicate if the monster is in an offensive phase. */
    bool m_offensive_phase;

    /** \brief The vector of defensive powers. */
    std::vector<bool> m_defensive_powers;

    /** \brief The vector of the offensive coefficients. */
    std::vector<unsigned int> m_offensive_coefficients;

    /** \brief Indicates if the monster is invincible. */
    bool m_invincible;

    /** \brief Which kind of monster am I ? */
    monster_type m_monster_type;

    /** \brief Indicates if the monster is injured. */
    bool m_is_injured;

    /** \brief Indicates the time of the attack. */
    bear::time_ref::time_reference m_injured_time;

    /** \brief The creator of the monster. */
    monster* m_creator;

  }; // class monster
} // namespace ptb

#endif // __PTB_MONSTER_HPP__
