/*
  Bear Engine

  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file applied_boolean_expression.cpp
 * \brief Implementation of the bear::applied_boolean_expression class.
 * \author Julien Jorge
 */
#include "generic_items/expr/applied_boolean_expression.hpp"

#include "engine/expr/base_boolean_expression.hpp"

#include "engine/export.hpp"

#include <claw/logger.hpp>

BASE_ITEM_EXPORT( applied_boolean_expression, bear )

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 */
bear::applied_boolean_expression::applied_boolean_expression()
  : m_expression(NULL)
{

} // applied_boolean_expression::applied_boolean_expression()

/*----------------------------------------------------------------------------*/
/**
 * \brief Set a field of type <item>.
 * \param name The name of the field.
 * \param value The value of the field.
 */
bool bear::applied_boolean_expression::set_item_field
( const std::string& name, engine::base_item* value )
{
  bool result = true;

  if ( name == "applied_boolean_expression.expression" )
    {
      engine::base_boolean_expression* e
        ( dynamic_cast<engine::base_boolean_expression*>(value) );

      if ( e != NULL )
        m_expression = e;
      else
        claw::logger << claw::log_error << name << ": item is not of type "
                     << "'engine::base_boolean_expression'." << std::endl;
    }
  else
    result = super::set_item_field(name, value);

  return result;
} // applied_boolean_expression::set_item_field()

/*----------------------------------------------------------------------------*/
/**
 * \brief Set a field of type <list of item>.
 * \param name The name of the field.
 * \param value The value of the field.
 */
bool bear::applied_boolean_expression::set_item_list_field
( const std::string& name, const std::vector<engine::base_item*>& value )
{
  bool result = true;

  if ( name == "applied_boolean_expression.trigger" )
    for ( std::size_t i=0; i!=value.size(); ++i )
      {
        engine::with_trigger* t
          ( dynamic_cast<engine::with_trigger*>(value[i]) );

        if ( t != NULL )
          m_trigger.push_back(t);
        else
          claw::logger << claw::log_error << name
                       << ": item #" << i
                       << " is not of type 'engine::with_trigger'."
                       << std::endl;
      }
  else
    result = super::set_item_list_field(name, value);

  return result;
} // applied_boolean_expression::set_item_list_field()

/*----------------------------------------------------------------------------*/
/**
 * \brief Tell if all required fields are initialized.
 */
bool bear::applied_boolean_expression::is_valid() const
{
  return !m_trigger.empty() && (m_expression != NULL);
} // applied_boolean_expression::is_valid()

/*----------------------------------------------------------------------------*/
/**
 * \brief Initialize the item.
 */
void bear::applied_boolean_expression::build()
{
  for (unsigned int i=0; i!=m_trigger.size(); ++i)
    m_trigger[i]->set_condition(*m_expression);

  kill();
} // applied_boolean_expression::build()
