/*
  Bear Engine

  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [BEAR] in the subject of your mails.
*/
/**
 * \file bool_game_variable_getter.cpp
 * \brief Implementation of the bear::bool_game_variable_getter class.
 * \author Julien Jorge
 */
#include "generic_items/game_variable/bool_game_variable_getter.hpp"

BASE_ITEM_EXPORT( bool_game_variable_getter, bear )

/*----------------------------------------------------------------------------*/
/**
 * \brief Contructor.
 */
bear::bool_game_variable_getter::bool_game_variable_getter()
{
  m_function.set_default_value(false);
} // bool_game_variable_getter::bool_game_variable_getter()

/*----------------------------------------------------------------------------*/
/**
 * \brief Initialize the item.
 */
void bear::bool_game_variable_getter::build()
{
  boolean_function_type::set_function(m_function);
} // bool_game_variable_getter::build()

/*----------------------------------------------------------------------------*/
/**
 * \brief Tell if the item is correctly initialized.
 */
bool bear::bool_game_variable_getter::is_valid() const
{
  return !m_function.get_name().empty() && super::is_valid();
} // bool_game_variable_getter::is_valid()

/*----------------------------------------------------------------------------*/
/**
 * \brief Set a field of type \c string.
 * \param name The name of the field.
 * \param value The new value of the field.
 * \return false if the field "name" is unknow, true otherwise.
 */
bool bear::bool_game_variable_getter::set_string_field
( const std::string& name, const std::string& value )
{
  bool result = true;

  if ( name == "bool_game_variable_getter.name" )
    m_function.set_name(value);
  else
    result = super::set_string_field(name,value);
  
  return result;
} // bool_game_variable_getter::set_string_field()

/*----------------------------------------------------------------------------*/
/**
 * \brief Set a field of type \c boolean.
 * \param name The name of the field.
 * \param value The new value of the field.
 * \return false if the field "name" is unknow, true otherwise.
 */
bool bear::bool_game_variable_getter::set_bool_field
( const std::string& name, bool value )
{
  bool result = true;

  if ( name == "bool_game_variable_getter.default_value" )
    m_function.set_default_value(value);
  else
    result = super::set_bool_field(name,value);
  
  return result;
} // bool_game_variable_getter::set_bool_field()
